/**
 * Beschrijft een postvak voor één brief.
 * 
 * @author Dominiek Vandewalle 
 * @version 2016-05-20
 */
public class EenvoudigPostvak extends Vak implements Postvak
{
    private String postnummer;
    private Brief brief;

    /**
     * Constructor voor objecten van de klases Postvak.
     * @param   postnummer  Het postnummer van de gemeente van de geadresseerde.
     */
    public EenvoudigPostvak(String postnummer)
    {
        super(postnummer);
    }
    
    /**
     * Controleert het postvak een geldige bestemming is van de brief.
     * @param   brief   Een brief.
     * @return  True indien de bestemming van de brief en het postnummer van het postvak overeen komen, anders false.
     */
    public boolean correctPostnummer(Brief brief)
    {
        return brief.getPostnummer().equals(super.getLabel());
    }
    
    /**
     * Plaatst de brief in het postvak. Een vorige brief gaat verloren.
     * De gebruiker controleert zelf of de bestemming geldig is.
     * @param   brief   De brief die in het postvak geplaatst wordt.
     */
    public void voegBriefToe(Brief brief)
    {
        this.brief = brief;
    }
}
